/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.INPCDisplay;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;
import org.apache.commons.codec.binary.Base64;

public class DataDisplay
implements INPCDisplay {
    EntityNPCInterface npc;
    public GameProfile playerProfile;
    public byte skinType = 0;
    private final Availability availability = new Availability();
    private BossInfo.Color bossColor = BossInfo.Color.PINK;
    private boolean disableLivingAnimation = false;
    private boolean isNormalModel = false;
    private byte hitboxState = 0;
    private byte showBossBar = 0;
    private int markovGender = 0;
    private int markovGeneratorId = new Random().nextInt(CustomNpcs.MARKOV_GENERATOR.length - 1);
    private int modelSize = 5;
    private int showName = 0;
    private int skinColor = 0xFFFFFF;
    private int visible = 0;
    private String cloakTexture = "";
    private String title = "";
    private String url = "";
    private String glowTexture = "";
    private String name;
    private String texture = "customnpcs:textures/entity/humanmale/steve.png";
    public float shadowSize = 1.0f;
    public float width = 0.6f;
    public float height = 1.9f;

    public DataDisplay(EntityNPCInterface npcIn) {
        this.npc = npcIn;
        this.name = this.getRandomName();
    }

    public Availability getAvailability() {
        return this.availability;
    }

    @Override
    public int getBossbar() {
        return this.showBossBar;
    }

    @Override
    public int getBossColor() {
        return this.bossColor.ordinal();
    }

    @Override
    public String getCapeTexture() {
        return this.cloakTexture;
    }

    @Override
    public int getHitboxState() {
        return this.hitboxState;
    }

    @Override
    public boolean isNormalModel() {
        return !this.isNormalModel;
    }

    @Override
    public boolean getHasLivingAnimation() {
        return !this.disableLivingAnimation;
    }

    public int getMarkovGender() {
        return this.markovGender;
    }

    public int getMarkovGeneratorId() {
        return this.markovGeneratorId;
    }

    @Override
    public String getModel() {
        if (!(this.npc instanceof EntityCustomNpc)) {
            return null;
        }
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        if (modeldata.entityClass == null) {
            return null;
        }
        String name = modeldata.entityClass.getCanonicalName();
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            Class c = ent.getEntityClass();
            if (!c.getCanonicalName().equals(name) || !EntityLivingBase.class.isAssignableFrom(c)) continue;
            return Objects.requireNonNull(ent.getRegistryName()).toString();
        }
        return null;
    }

    @Override
    public float[] getModelScale(int part) {
        if (!(this.npc instanceof EntityCustomNpc)) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        ModelPartConfig model = null;
        if (part == 0) {
            model = modeldata.getPartConfig(EnumParts.HEAD);
        } else if (part == 1) {
            model = modeldata.getPartConfig(EnumParts.BODY);
        } else if (part == 2) {
            model = modeldata.getPartConfig(EnumParts.ARM_LEFT);
        } else if (part == 3) {
            model = modeldata.getPartConfig(EnumParts.ARM_RIGHT);
        } else if (part == 4) {
            model = modeldata.getPartConfig(EnumParts.LEG_LEFT);
        } else if (part == 5) {
            model = modeldata.getPartConfig(EnumParts.LEG_RIGHT);
        }
        if (model == null) {
            throw new CustomNPCsException("Unknown part: " + part, new Object[0]);
        }
        return new float[]{model.scale[0], model.scale[1], model.scale[2]};
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOverlayTexture() {
        return this.glowTexture;
    }

    public String getRandomName() {
        return CustomNpcs.MARKOV_GENERATOR[this.markovGeneratorId].fetch(this.markovGender);
    }

    @Override
    public int getShadowType() {
        if (this.shadowSize < 0.5f) {
            return 0;
        }
        if (this.shadowSize < 1.0f) {
            return 1;
        }
        if (this.shadowSize < 1.5f) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getShowName() {
        return this.showName;
    }

    @Override
    public int getSize() {
        return this.modelSize;
    }

    @Override
    public String getSkinPlayer() {
        return this.playerProfile == null ? "" : this.playerProfile.getName();
    }

    @Override
    public String getSkinTexture() {
        return this.texture;
    }

    @Override
    public String getSkinUrl() {
        return this.url;
    }

    @Override
    public int getTint() {
        return this.skinColor;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getVisible() {
        return this.visible;
    }

    public boolean hasVisibleOptions() {
        return CustomNpcs.EnableInvisibleNpcs && this.availability.hasOptions();
    }

    public boolean isVisibleTo(EntityPlayerMP player) {
        if (this.visible == 1) {
            return !this.availability.isAvailable((EntityPlayer)player);
        }
        return true;
    }

    @Override
    public boolean isVisibleTo(IPlayer<?> player) {
        return this.npc.func_98034_c((EntityPlayer)player.getMCEntity());
    }

    public void loadProfile() {
        GameProfile gameprofile;
        if (!(this.playerProfile == null || StringUtils.func_151246_b((String)this.playerProfile.getName()) || this.npc.func_184102_h() == null || this.playerProfile.isComplete() && this.playerProfile.getProperties().containsKey((Object)"textures") || (gameprofile = this.npc.func_184102_h().func_152358_ax().func_152655_a(this.playerProfile.getName())) == null)) {
            Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
            if (property == null) {
                gameprofile = this.npc.func_184102_h().func_147130_as().fillProfileProperties(gameprofile, true);
            }
            this.playerProfile = gameprofile;
        }
    }

    public void readToNBT(NBTTagCompound displayNbt) {
        this.setName(displayNbt.func_74779_i("Name"));
        this.setMarkovGeneratorId(displayNbt.func_74762_e("MarkovGeneratorId"));
        this.setMarkovGender(displayNbt.func_74762_e("MarkovGender"));
        this.title = displayNbt.func_74779_i("Title");
        byte prevSkinType = this.skinType;
        String prevTexture = this.texture;
        String prevUrl = this.url;
        String prevPlayer = this.getSkinPlayer();
        this.url = displayNbt.func_74779_i("SkinUrl");
        this.skinType = displayNbt.func_74771_c("UsingSkinUrl");
        this.texture = displayNbt.func_74779_i("Texture");
        this.cloakTexture = displayNbt.func_74779_i("CloakTexture");
        this.glowTexture = displayNbt.func_74779_i("GlowTexture");
        this.playerProfile = null;
        if (!this.url.isEmpty() && !this.url.startsWith("http")) {
            try {
                String json = new String(Base64.decodeBase64((String)this.url), StandardCharsets.UTF_8);
                Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
                MinecraftTexturesPayload mtp = (MinecraftTexturesPayload)gson.fromJson(json, MinecraftTexturesPayload.class);
                MinecraftProfileTexture mpt = (MinecraftProfileTexture)mtp.getTextures().get(MinecraftProfileTexture.Type.SKIN);
                if (!mpt.getUrl().isEmpty()) {
                    this.url = mpt.getUrl();
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        if (this.skinType == 1) {
            if (displayNbt.func_150297_b("SkinUsername", 10)) {
                this.playerProfile = NBTUtil.func_152459_a((NBTTagCompound)displayNbt.func_74775_l("SkinUsername"));
            } else if (displayNbt.func_150297_b("SkinUsername", 8) && !StringUtils.func_151246_b((String)displayNbt.func_74779_i("SkinUsername"))) {
                this.playerProfile = new GameProfile(null, displayNbt.func_74779_i("SkinUsername"));
            }
            this.loadProfile();
        }
        this.modelSize = ValueUtil.correctInt(displayNbt.func_74762_e("Size"), 1, 30);
        this.showName = displayNbt.func_74762_e("ShowName");
        if (displayNbt.func_74764_b("SkinColor")) {
            this.skinColor = displayNbt.func_74762_e("SkinColor");
        }
        this.visible = displayNbt.func_74762_e("NpcVisible");
        this.availability.load(displayNbt.func_74775_l("VisibleAvailability"));
        this.disableLivingAnimation = displayNbt.func_74767_n("NoLivingAnimation");
        this.hitboxState = displayNbt.func_74771_c("IsStatue");
        this.isNormalModel = displayNbt.func_74767_n("HasJoints");
        this.setBossbar(displayNbt.func_74771_c("BossBar"));
        this.setBossColor(displayNbt.func_74762_e("BossColor"));
        if (!(prevSkinType == this.skinType && this.texture.equals(prevTexture) && this.url.equals(prevUrl) && this.getSkinPlayer().equals(prevPlayer))) {
            this.npc.textureLocation = null;
        }
        this.npc.textureGlowLocation = null;
        this.npc.textureCloakLocation = null;
        this.npc.updateHitbox();
        this.shadowSize = displayNbt.func_150297_b("ShadowSize", 5) ? ValueUtil.correctFloat(displayNbt.func_74760_g("ShadowSize"), 0.0f, 1.5f) : 1.0f;
        if (displayNbt.func_150297_b("HitBoxWidth", 5)) {
            this.width = ValueUtil.correctFloat(displayNbt.func_74760_g("HitBoxWidth"), 0.0f, 5.0f);
        }
        if (displayNbt.func_150297_b("HitBoxHeight", 5)) {
            this.height = ValueUtil.correctFloat(displayNbt.func_74760_g("HitBoxHeight"), 0.0f, 10.0f);
        }
        if (this.hitboxState != 1 && (this.width != 0.0f || this.height != 0.0f)) {
            this.npc.baseWidth = this.width;
            this.npc.baseHeight = this.height;
            this.npc.updateHitbox();
        }
        CustomNpcs.visibilityController.trackNpc(this.npc);
    }

    @Override
    public void setBossbar(int type) {
        if (type == this.showBossBar) {
            return;
        }
        this.showBossBar = (byte)ValueUtil.correctInt(type, 0, 2);
        this.npc.bossInfo.func_186758_d(this.showBossBar == 1);
        this.npc.updateClient = true;
    }

    @Override
    public void setBossColor(int color) {
        if (color < 0 || color >= BossInfo.Color.values().length) {
            throw new CustomNPCsException("Invalid Boss Color: " + color, new Object[0]);
        }
        this.bossColor = BossInfo.Color.values()[color];
        this.npc.bossInfo.func_186745_a(this.bossColor);
    }

    @Override
    public void setCapeTexture(String texture) {
        if (this.cloakTexture.equals(texture)) {
            return;
        }
        this.cloakTexture = texture.toLowerCase();
        this.npc.textureCloakLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public void setHitboxState(int state) {
        if (this.hitboxState == (state = ValueUtil.correctInt(state, 0, 2))) {
            return;
        }
        this.hitboxState = (byte)state;
        this.npc.updateClient = true;
    }

    @Override
    public void setNormalModel(boolean bo) {
        if (this.isNormalModel == bo) {
            return;
        }
        this.isNormalModel = bo;
        this.npc.updateClient = true;
    }

    @Override
    public void setHasLivingAnimation(boolean enabled) {
        this.disableLivingAnimation = !enabled;
        this.npc.updateClient = true;
    }

    public void setMarkovGender(int gender) {
        if (this.markovGender == gender) {
            return;
        }
        this.markovGender = ValueUtil.correctInt(gender, 0, 2);
    }

    public void setMarkovGeneratorId(int id) {
        if (this.markovGeneratorId == id) {
            return;
        }
        this.markovGeneratorId = ValueUtil.correctInt(id, 0, CustomNpcs.MARKOV_GENERATOR.length - 1);
    }

    @Override
    public void setModel(String id) {
        if (!(this.npc instanceof EntityCustomNpc)) {
            return;
        }
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        if (id == null) {
            if (modeldata.entityClass == null) {
                return;
            }
            modeldata.entityClass = null;
        } else {
            ResourceLocation resource = new ResourceLocation(id);
            Entity entity = EntityList.func_188429_b((ResourceLocation)resource, (World)this.npc.field_70170_p);
            if (entity == null) {
                throw new CustomNPCsException("Failed to create an entity from given id: " + id, new Object[0]);
            }
            modeldata.setEntityName(entity.getClass().getCanonicalName());
        }
        this.npc.updateClient = true;
    }

    @Override
    public void setModelScale(int part, float x, float y, float z) {
        if (!(this.npc instanceof EntityCustomNpc)) {
            return;
        }
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        ModelPartConfig model = null;
        if (part == 0) {
            model = modeldata.getPartConfig(EnumParts.HEAD);
        } else if (part == 1) {
            model = modeldata.getPartConfig(EnumParts.BODY);
        } else if (part == 2) {
            model = modeldata.getPartConfig(EnumParts.ARM_LEFT);
        } else if (part == 3) {
            model = modeldata.getPartConfig(EnumParts.ARM_RIGHT);
        } else if (part == 4) {
            model = modeldata.getPartConfig(EnumParts.LEG_LEFT);
        } else if (part == 5) {
            model = modeldata.getPartConfig(EnumParts.LEG_RIGHT);
        }
        if (model == null) {
            throw new CustomNPCsException("Unknown part: " + part, new Object[0]);
        }
        model.setScale(x, y, z);
        this.npc.updateClient = true;
    }

    @Override
    public void setName(String newName) {
        if (this.name.equals(newName)) {
            return;
        }
        this.name = newName;
        this.npc.bossInfo.func_186739_a(this.npc.func_145748_c_());
        this.npc.updateClient = true;
    }

    @Override
    public void setOverlayTexture(String texture) {
        if (this.glowTexture.equals(texture)) {
            return;
        }
        this.glowTexture = texture;
        this.npc.textureGlowLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public void setShadowType(int type) {
        if (type < 0) {
            type *= -1;
        }
        switch (type % 4) {
            case 0: {
                this.shadowSize = 0.0f;
                break;
            }
            case 1: {
                this.shadowSize = 0.5f;
                break;
            }
            case 2: {
                this.shadowSize = 1.0f;
                break;
            }
            default: {
                this.shadowSize = 1.5f;
            }
        }
    }

    @Override
    public void setShowName(int type) {
        if (type == this.showName) {
            return;
        }
        this.showName = ValueUtil.correctInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    @Override
    public void setSize(int size) {
        if (this.modelSize == size) {
            return;
        }
        this.modelSize = ValueUtil.correctInt(size, 1, 30);
        this.npc.updateClient = true;
    }

    @Override
    public void setSkinPlayer(String name) {
        if (name == null || name.isEmpty()) {
            this.playerProfile = null;
            this.skinType = 0;
        } else {
            this.playerProfile = new GameProfile(null, name);
            this.skinType = 1;
        }
        this.npc.updateClient = true;
    }

    @Override
    public void setSkinTexture(String newTexture) {
        if (newTexture == null || this.texture.equals(newTexture)) {
            return;
        }
        this.texture = newTexture.toLowerCase();
        this.npc.textureLocation = null;
        this.skinType = 0;
        this.npc.updateClient = true;
    }

    @Override
    public void setSkinUrl(String newURL) {
        if (this.url.equals(newURL)) {
            return;
        }
        this.url = newURL;
        this.skinType = this.url.isEmpty() ? (byte)0 : (byte)2;
        this.npc.updateClient = true;
    }

    @Override
    public void setTint(int color) {
        if (color == this.skinColor) {
            return;
        }
        this.skinColor = color;
        this.npc.updateClient = true;
    }

    @Override
    public void setTitle(String newTitle) {
        if (this.title.equals(newTitle)) {
            return;
        }
        this.title = newTitle;
        this.npc.updateClient = true;
    }

    @Override
    public void setVisible(int type) {
        if (type == this.visible) {
            return;
        }
        this.visible = ValueUtil.correctInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    public boolean showName() {
        return !this.npc.isKilled() && (this.showName == 0 || this.showName == 2 && this.npc.isAttacking());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound displayNbt) {
        displayNbt.func_74778_a("Name", this.name);
        displayNbt.func_74768_a("MarkovGeneratorId", this.markovGeneratorId);
        displayNbt.func_74768_a("MarkovGender", this.markovGender);
        displayNbt.func_74778_a("Title", this.title);
        displayNbt.func_74778_a("SkinUrl", this.url);
        displayNbt.func_74778_a("Texture", this.texture);
        displayNbt.func_74778_a("CloakTexture", this.cloakTexture);
        displayNbt.func_74778_a("GlowTexture", this.glowTexture);
        displayNbt.func_74774_a("UsingSkinUrl", this.skinType);
        if (this.playerProfile != null) {
            NBTTagCompound displayNbt2 = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)displayNbt2, (GameProfile)this.playerProfile);
            displayNbt.func_74782_a("SkinUsername", (NBTBase)displayNbt2);
        }
        displayNbt.func_74768_a("Size", this.modelSize);
        displayNbt.func_74768_a("ShowName", this.showName);
        displayNbt.func_74768_a("SkinColor", this.skinColor);
        displayNbt.func_74768_a("NpcVisible", this.visible);
        displayNbt.func_74782_a("VisibleAvailability", (NBTBase)this.availability.save(new NBTTagCompound()));
        displayNbt.func_74757_a("NoLivingAnimation", this.disableLivingAnimation);
        displayNbt.func_74774_a("IsStatue", this.hitboxState);
        displayNbt.func_74757_a("HasJoints", this.isNormalModel);
        displayNbt.func_74774_a("BossBar", this.showBossBar);
        displayNbt.func_74768_a("BossColor", this.bossColor.ordinal());
        displayNbt.func_74757_a("EnableInvisibleNpcs", CustomNpcs.EnableInvisibleNpcs);
        displayNbt.func_74776_a("ShadowSize", this.shadowSize);
        displayNbt.func_74776_a("HitBoxWidth", this.width);
        displayNbt.func_74776_a("HitBoxHeight", this.height);
        return displayNbt;
    }
}

